#!/usr/bin/perl 
use CGI::Carp qw(fatalsToBrowser);
use Text::Wrap;
#
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 2000 T. O' Donnell, Inc.  All Rights Reserved.                   #
#                                                                            #
# This script may be used and modified free of charge by anyone so long as   #
# this copyright notice and the comments above remain intact.  By using this #
# code you agree to indemnify T. O' Donnell, Inc. and T. O' Donnell from any #
# liability that might arise from its use.                                   #  
#                                                                            #
# Selling the code for this program without prior written consent is         #
# expressly forbidden.  In other words, please ask first before you try      #
# to make money off of my program.                                           #
#                                                                            #
# Obtain permission before redistributing this software over the Internet or #
# in any other medium.  In all cases copyright and header must remain intact.#
# This Copyright is in full effect in any country that has International     #
# Trade Agreements with the United Kingdom.                                  #
##############################################################################
#
# Required fields and email address validity sub-routines adapted from :
##############################################################################
# Cliff's Form Mailer Version 1.0                                            # 
# Copyright 1998 Shaven Ferret Productions                                   #
# Created 6/4/98                                                             #
# Available at http://www.shavenferret.com/scripts                           #
##############################################################################

########################### Define Variables Section #########################

########################### Location of Programs #############################

# Path to mail program :

$mailprog = '/usr/lib/sendmail';

########################### Necessary URLs ##########################################

# List the URL's that are allowed to call this script :

@valid_urls = ('www.tigertom.com','tigertom.com');

# Url of page to send user to when script is finished :

$thanksurl = 'http://www.tigertom.com/thanks4.htm';


#######################################################################

# Password to allow mail-out via this script.
# Tip: The password should be at least 8 characters' long, be composed 
# of both numbers and letters, and both upper and lowercase letters. 
# CHANGE it, and DON'T make it a short, easily-guessed word :

$the_password = 'pa55w0rd';


############################ String Length / Text Wrapping ###################

# At greater than what length should the script consider wrapping text input?  
# [Set this to a very large number if you don't want the script to mess with 
# long form input strings.]

$string_limit = '100';

# And at what length should it start wrap the text?

$wrap_at = '65';


################################ Security ##########################################

# Extra security - this line defines what directories programs 
# can be executed from on your server, by this script :

$ENV{'PATH'} = '/bin:/usr/bin:/usr/local/bin:/usr/sbin';

# Allow HTML? (characters like " # >)
# If you enable this, make sure you put the script
# somewhere safe, like in a password protected directory.
# Set to 1 if you want to be able to enter characters like this.

$allow_html = 0;
 

############################# Required Fields ######################################

# Enter the form fields that are required to be filled, or leave blank 
# like so i.e. nothing between the brackets:

# @required = (); 

@required = ('name','email','sender_name','sender_email','message','password');


########################## DO NOT EDIT BELOW THIS LINE ###########################

### End of main user-defined variables. Do not edit below this line, unless you 
### know what you're doing. If you do, you should keep a working, back-up copy of 
### what you've done so far.   

#################################### The Sub-Routine Order #######################

&parse_data;

&secure_check;

&required_check;

&email_check;

&send_email;

&thanks_url;

exit 0;


#########################The Sub-Routines ##########################

# Now get the input (having executed the secure_check sub-routine)  : 

sub parse_data {
  
    read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'}); 
         
    # Split the name-value pairs
    @pairs = split(/&/, $buffer);

    foreach $pair (@pairs) {
    
    ($name, $value) = split(/=/, $pair);

    # Un-Webify plus signs and %-encoding
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

if(!$allow_html) {
    $value =~ s/\</\&lt\;/g;  # html tag removal (optional)
    $value =~ s/\>/\&gt\;/g;  # html tag removal (optional)
    $value =~ s/\"/&quot\;/g; # Quotation mark substitution
	} # End if
    # Stop people from using subshells to execute commands
    # Not a big deal when using sendmail, but very important
    # when using UCB mail (aka mailx).
      $value =~ s/~!/ ~!/g;

    # Uncomment for debugging purposes
    # print "Setting $name to $value<P>";

    $FORM{$name} = $value;

# Wrap long messages [large values]
$Text::Wrap::columns=$wrap_at; # This is the line length for your mail message text.

# If the length of a value/string is greater than that
# which we've specified, wrap it
if (length($value) > $string_limit) {           
$value = wrap("\t","", $value);
              } # End if

      
     }
  }

################################################################################



# From Cliff's Form Script: Check for all required fields

sub required_check {

foreach $field(@required) {
        unless ($FORM{$field}) {
print "Content-type: text/html\n\n";
print <<"EOF";

<html><head><title>Missing Info.</title></head>
<body><h2>Error - Missing Form Information:</h2>
It seems that you've forgotten to fill out the<br> 
<big><b>$field</b></big> field in the form.<BR><BR>
Please use your browser's BACK button and correct this.<BR>
Thank You.
</body></html>

EOF

exit;
       }
    }
 }

# From Cliff's Form Script: Check the email addresses' basic validity :

sub email_check {

if ($FORM{'email'} || $FORM{'sender_email'}) {
        unless ($FORM{'email'} =~ /.+\@.+\.+/ && $FORM{'sender_email'} =~ /.+\@.+\.+/) {
print "Content-type: text/html\n\n";        

print <<"EOF";

<html><head><title>Email Address Error?</title></head>
<body><h2><center>Email Address Error.</h2><br></center><br>
<center>The email address that you've entered:</center><br> 
<center><b>$FORM{'email'} or $FORM{'sender_email'}</b></big></center><br>
<center>is not quite correct.</center>
<center>Please use your browser's BACK button and correct it.</center>
<center>Thank You.</center>
</body></html>

EOF

exit;
        }
     }
 }


sub send_email {  

open (MAIL, "|$mailprog -oi -t") || die "Error - cannot open mail program";
print MAIL ("From: $FORM{'sender_name'} <$FORM{'sender_email'}>\n");
print MAIL ("To: $FORM{'name'} <$FORM{'email'}>\n");
print MAIL ("Reply-To: $FORM{'sender_email'}\n");
   if ($FORM{'carbon'} ne "") {
print MAIL ("Cc: <$FORM{'carbon'}>\n");
 }
   if ($FORM{'blind_carbon'} ne "") {
print MAIL ("Bcc: <$FORM{'blind_carbon'}>\n");
 }
print MAIL ("Subject: $FORM{'subject'}\n\n"); 
print MAIL "$FORM{'message'}";
print MAIL "\n";
print MAIL "-" x 25 . "\n";
print MAIL "\n";

close (MAIL);

  }


# 'Thank You' page URL to go to :


 sub thanks_url {

 if ($thanksurl ne "") {

 print "Location: $thanksurl\n\n";

   }
 }

sub secure_check {

  #  Check that the correct form URL is using this script : 

 $invalid_referer = "1";
  if($ENV{'HTTP_REFERER'}) {
 foreach $referer(@valid_urls) {
	if($ENV{'HTTP_REFERER'} =~ m|https?://([^/]*)$referer|i){
	$invalid_referer = "0";
       last;	
	     } # End if
         } # End foreach
       } # End if
 if ($invalid_referer eq "1") { 
 print "Content-type: text/html\n\n";        

print <<"EOF";

<html><head><title>Referer Error?</title></head>
<body><h2><center>Referer Error.</center></h2><br></center><br>
<center>URL $ENV{'HTTP_REFERER'} may not use this script.</center>
</body></html>

EOF

exit;
    } # End if
  } # End sub
  
    # Now check request method :

    if ($ENV{'REQUEST_METHOD'} eq 'GET') {
   
    # Stop the script
   
    print "Content-type: text/html\n\n";
    print "<html><head><title>Unauthorised Request Method GET</title></head>\n";
    print "<body><center><h2>Unauthorised Request Method GET.</h2></center><br>\n\n";
    print "<center><i>Stopping this transaction now.</i></center><br>\n\n";
    print "<center>Webmaster, configure your form with the action POST.</center></body></html>\n\n";
    exit(0);
    
     } # End if

unless($FORM{'password'} eq "$the_password") {
   &webmaster_alert;
   exit(0);
      }

  } # End sub



sub webmaster_alert {

&get_date;
        print "Content-type: text/html\n\n";
        print  "<B>That is an incorrect password.</B><br>\n";
        print  "The following information has been emailed to the webmaster:<BR>\n";
        print  "Referer       : $ENV{'HTTP_REFERER'}<BR>\n";
        print  "IP Number     : $ENV{'REMOTE_ADDR'}<BR>\n";
        print  "Browser       : $ENV{'HTTP_USER_AGENT'}<BR>\n";
        print  "Proxy (if any): $ENV{'HTTP_FORWARDED'}<BR>\n";
        print  "Server time   : $time $date\n";
      
         

 open (MAIL,"|$mailprog -oi -t") || die "Error - cannot open $mailprog!:$_";
 
 print MAIL ("From: \"Hack Alert Sub-Routine\" <YourScript\@yoursite.net>\n");
 print MAIL ("To: $webmaster\n");
 print MAIL ("Reply-To: <YourScript\@YourSite.net>\n");
 print MAIL ("Subject: Possible Hack Attempt\n\n"); 
 print MAIL "Someone has attempted to access $ENV{'SCRIPT_NAME'}\n";
 print MAIL "without using the correct password.\n";
 print MAIL "Referer       : $ENV{'HTTP_REFERER'}\n";
 print MAIL "IP Number     : $ENV{'REMOTE_ADDR'}\n";
 print MAIL "Browser       : $ENV{'HTTP_USER_AGENT'}\n";
 print MAIL "Proxy (if any): $ENV{'HTTP_FORWARDED'}\n";
 print MAIL "Server time   : $time $date\n";
 print MAIL "\n";
 print MAIL "=" x 60 . "\n";
 print MAIL "\n";

close(MAIL);
exit(0);

   }


# Get the date:

sub get_date {


        ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
        $mon++;
        if ($sec < 10) { $sec = "0$sec"; }
        if ($min < 10) { $min = "0$min"; }
        if ($hour < 10) { $hour = "0$hour"; }
        if ($mday < 10) { $mday = "0$mday"; }
        if ($year < 70){$year = ($year + 2000);}
            else {$year = ($year + 1900);}
        $date = "$mon/$mday/$year";
        $time = "$hour:$min:$sec";
 }


   
